/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.item;

import java.util.HashMap;
import java.util.Map;
import net.jayjay.dangerzone.item.Item;
import net.jayjay.dangerzone.item.ItemDynamite;
import net.jayjay.dangerzone.item.ItemFood;
import net.jayjay.dangerzone.item.ItemSpawnEgg;

public class Items {
    private static final Map<String, Item> itemRegistry = new HashMap<String, Item>();
    private static final Map<String, Integer> tagToId = new HashMap<String, Integer>();
    public static int nextId = 0;
    public static int itemLimit = -1;
    public static final Item[] items = new Item[4096];
    public static final Item empty = null;
    public static final Item itemNull = new Item("dz2:item_null", "/items/null.png");
    public static final Item oakStick = new Item("dz2:oak_stick", "/items/stick.png");
    public static final Item donut = new ItemFood("dz2:donut", "/items/donut.png", 25);
    public static final Item stoneShovel = new Item("dz2:stone_shovel", "/items/stone_shovel.png");
    public static final Item stonePickaxe = new Item("dz2:stone_pickaxe", "/items/stone_pickaxe.png");
    public static final Item dynamiteStick = new ItemDynamite("dz2:dynamite_stick", "/items/dynamite.png", 10.0f);
    public static final Item superDynamiteStick = new ItemDynamite("dz2:super_dynamite_stick", "/items/dynamite.png", 100.0f);
    public static final Item supererDynamiteStick = new ItemDynamite("dz2:superer_dynamite_stick", "/items/dynamite.png", 1000.0f);
    public static final Item superererDynamiteStick = new ItemDynamite("dz2:supererer_dynamite_stick", "/items/dynamite.png", 5000.0f);
    public static final Item bloodMonsterEgg = new ItemSpawnEgg("dz2:blood_monster_egg", "/items/blood_monster_egg.png");

    public static void registerItem(Item item) {
        itemRegistry.put(item.itemTag, item);
        tagToId.put(item.itemTag, nextId);
        Items.items[Items.nextId] = item;
        ++nextId;
    }

    public static void registerItem(Item item, String tag) {
        itemRegistry.put(tag, item);
        tagToId.put(tag, nextId);
        Items.items[Items.nextId] = item;
        ++nextId;
    }

    public static Item getItem(String tag) {
        return itemRegistry.get(tag);
    }

    public static int getItemID(String tag) {
        return tagToId.getOrDefault(tag, -1);
    }

    public static Item getItemById(int id) {
        if (id >= 0 && id < items.length) {
            return items[id];
        }
        return null;
    }
}

